/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.roadstuff.proxy;

import java.util.function.Predicate;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.RegistryObject;
import tv.mapper.roadstuff.proxy.IProxy;
import tv.mapper.roadstuff.util.ModColorHandler;
import tv.mapper.roadstuff.world.item.BrushItem;
import tv.mapper.roadstuff.world.item.RSItemRegistry;
import tv.mapper.roadstuff.world.level.block.RSBlockRegistry;

public class ClientProxy
implements IProxy {
    @Override
    public void setup(FMLCommonSetupEvent event) {
        ModColorHandler.registerBlockColor();
        Predicate<RenderType> cutoutPredicate = renderType -> renderType == RenderType.m_110463_();
        for (RegistryObject<Block> registryObject : RSBlockRegistry.MOD_PAINTABLEBLOCKS) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), cutoutPredicate);
        }
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)RSBlockRegistry.PAINT_BUCKET.get()), cutoutPredicate);
        ItemProperties.register((Item)((Item)RSItemRegistry.PAINT_BUCKET_ITEM.get()), (ResourceLocation)new ResourceLocation("color"), (itemStack, world, entity, id) -> {
            if (itemStack.m_41782_()) {
                CompoundTag nbt = itemStack.m_41783_();
                if (nbt.m_128451_("paint") == 0) {
                    return 0.0f;
                }
                if (nbt.m_128451_("color") == 0) {
                    return 0.5f;
                }
                if (nbt.m_128451_("color") == 1) {
                    return 1.0f;
                }
            }
            return 0.0f;
        });
        for (RegistryObject<Block> registryObject : RSItemRegistry.MOD_PAINTBRUSHES) {
            ItemProperties.register((Item)((Item)registryObject.get()), (ResourceLocation)new ResourceLocation("color"), (itemStack, world, entity, id) -> {
                CompoundTag nbt = BrushItem.checkNBT(itemStack);
                if (nbt.m_128451_("paint") == 0) {
                    return 0.0f;
                }
                if (nbt.m_128451_("color") == 0) {
                    return 0.5f;
                }
                if (nbt.m_128451_("color") == 1) {
                    return 1.0f;
                }
                return 0.0f;
            });
        }
    }
}

